<?php
error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

include_once '../config/database.php';

// Check if file and workshop_id are present
if (!isset($_FILES['image']) || !isset($_POST['workshop_id'])) {
    http_response_code(400);
    echo json_encode(array("message" => "Missing image or workshop_id"));
    exit();
}

$workshop_id = $_POST['workshop_id'];
$file = $_FILES['image'];

// Validate file
$allowed_types = array('image/jpeg', 'image/png', 'image/gif', 'image/webp');
if (!in_array($file['type'], $allowed_types)) {
    http_response_code(400);
    echo json_encode(array("message" => "Invalid file type. Only JPEG, PNG, GIF, WEBP allowed."));
    exit();
}

// Max 5MB
if ($file['size'] > 5 * 1024 * 1024) {
    http_response_code(400);
    echo json_encode(array("message" => "File too large. Maximum 5MB allowed."));
    exit();
}

// Create uploads directory if not exists
$upload_dir = '../uploads/workshops/';
if (!file_exists($upload_dir)) {
    mkdir($upload_dir, 0777, true);
}

// Generate unique filename
$extension = pathinfo($file['name'], PATHINFO_EXTENSION);
$filename = 'workshop_' . $workshop_id . '_' . time() . '.' . $extension;
$filepath = $upload_dir . $filename;

// Move uploaded file
if (move_uploaded_file($file['tmp_name'], $filepath)) {
    // Update database with image URL
    $image_url = 'http://localhost/bengkelku_api/uploads/workshops/' . $filename;
    
    $query = "UPDATE workshops SET image = :image WHERE workshop_id = :workshop_id";
    $stmt = $db->prepare($query);
    $stmt->bindParam(':image', $image_url);
    $stmt->bindParam(':workshop_id', $workshop_id);
    
    if ($stmt->execute()) {
        http_response_code(200);
        echo json_encode(array(
            "message" => "Image uploaded successfully.",
            "image_url" => $image_url
        ));
    } else {
        http_response_code(503);
        echo json_encode(array("message" => "Failed to update database."));
    }
} else {
    http_response_code(503);
    echo json_encode(array("message" => "Failed to upload image."));
}
?>
