<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

include_once '../config/database.php';

$data = json_decode(file_get_contents("php://input"));

if (empty($data->workshop_id)) {
    http_response_code(400);
    echo json_encode(array("message" => "Missing workshop_id"));
    exit();
}

$query = "UPDATE workshops SET name = :name, address = :address, phone = :phone, open_hours = :open_hours WHERE workshop_id = :workshop_id";

$stmt = $db->prepare($query);
$stmt->bindParam(':workshop_id', $data->workshop_id);
$stmt->bindParam(':name', $data->name);
$stmt->bindParam(':address', $data->address);
$stmt->bindParam(':phone', $data->phone);
$open_hours = isset($data->open_hours) ? $data->open_hours : '08:00-17:00';
$stmt->bindParam(':open_hours', $open_hours);

if ($stmt->execute()) {
    http_response_code(200);
    echo json_encode(array("message" => "Workshop updated."));
} else {
    http_response_code(503);
    echo json_encode(array("message" => "Unable to update workshop."));
}
?>
