<?php
include_once '../config/database.php';

$id = isset($_GET['id']) ? $_GET['id'] : die();

// 1. Get Workshop Info
$query = "SELECT * FROM workshops WHERE workshop_id = :id";
$stmt = $db->prepare($query);
$stmt->bindParam(':id', $id);
$stmt->execute();
$workshop = $stmt->fetch(PDO::FETCH_ASSOC);

if($workshop) {
    // 2. Get Services
    $query_services = "SELECT * FROM services WHERE workshop_id = :id";
    $stmt_services = $db->prepare($query_services);
    $stmt_services->bindParam(':id', $id);
    $stmt_services->execute();
    
    $services = array();
    while ($row = $stmt_services->fetch(PDO::FETCH_ASSOC)) {
        array_push($services, $row);
    }
    
    // If empty services (dummy data insertion for testing)
    if(count($services) == 0) {
        $services = [
            ["service_id" => 101, "service_name" => "Ganti Oli Mesin", "price" => 50000, "category" => "servis_rutin"],
            ["service_id" => 102, "service_name" => "Tune Up Ringan", "price" => 75000, "category" => "servis_rutin"],
            ["service_id" => 103, "service_name" => "Tambal Ban Tubeless", "price" => 20000, "category" => "tambal_ban"]
        ];
    }

    $workshop['services'] = $services;

    // 3. Get Reviews
    $query_reviews = "SELECT r.*, u.full_name as user_name, u.profile_image 
                      FROM reviews r 
                      JOIN users u ON r.user_id = u.user_id 
                      WHERE r.workshop_id = :id 
                      ORDER BY r.created_at DESC";
    $stmt_reviews = $db->prepare($query_reviews);
    $stmt_reviews->bindParam(':id', $id);
    $stmt_reviews->execute();
    
    $reviews = array();
    while ($row = $stmt_reviews->fetch(PDO::FETCH_ASSOC)) {
        array_push($reviews, $row);
    }
    $workshop['reviews'] = $reviews;

    echo json_encode(array("data" => $workshop));
} else {
    http_response_code(404);
    echo json_encode(array("message" => "Workshop not found."));
}
?>
