<?php
error_reporting(0);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

include_once '../config/database.php';

$query = "SELECT * FROM workshops";
$stmt = $db->prepare($query);
$stmt->execute();

$num = $stmt->rowCount();

if($num > 0) {
    $workshops_arr = array();
    $workshops_arr["data"] = array();

    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $workshop_item = array(
            "workshop_id" => $row['workshop_id'],
            "name" => $row['name'],
            "lat" => isset($row['latitude']) ? $row['latitude'] : null,
            "lng" => isset($row['longitude']) ? $row['longitude'] : null,
            "address" => isset($row['address']) ? $row['address'] : '',
            "rating" => isset($row['rating']) ? $row['rating'] : 4.5,
            "image" => isset($row['image']) ? $row['image'] : (isset($row['image_url']) ? $row['image_url'] : null),
            "is_open" => isset($row['is_open']) ? (bool)$row['is_open'] : true
        );
        array_push($workshops_arr["data"], $workshop_item);
    }
    http_response_code(200);
    echo json_encode($workshops_arr);
} else {
    http_response_code(404);
    echo json_encode(array("message" => "No workshops found."));
}
?>
