<?php
include_once '../config/database.php';

$user_id = isset($_GET['user_id']) ? $_GET['user_id'] : die();

$query = "SELECT * FROM vehicles WHERE user_id = :user_id ORDER BY vehicle_id DESC";
$stmt = $db->prepare($query);
$stmt->bindParam(':user_id', $user_id);
$stmt->execute();

$num = $stmt->rowCount();

if($num > 0) {
    $vehicles_arr = array();
    $vehicles_arr["data"] = array();

    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)){
        extract($row);
        $vehicle_item = array(
            "vehicle_id" => $vehicle_id,
            "brand" => $brand,
            "model" => $model,
            "year" => $year,
            "plate_number" => $plate_number
        );
        array_push($vehicles_arr["data"], $vehicle_item);
    }
    http_response_code(200);
    echo json_encode($vehicles_arr);
} else {
    http_response_code(404);
    echo json_encode(array("message" => "No vehicles found."));
}
?>
