<?php
include_once '../config/database.php';

$data = json_decode(file_get_contents("php://input"));

if(!empty($data->vehicle_id)) {
    $query = "DELETE FROM vehicles WHERE vehicle_id = :vehicle_id";
    $stmt = $db->prepare($query);
    $stmt->bindParam(":vehicle_id", $data->vehicle_id);

    if($stmt->execute()){
        http_response_code(200);
        echo json_encode(array("message" => "Vehicle deleted."));
    } else{
        http_response_code(503);
        echo json_encode(array("message" => "Unable to delete vehicle."));
    }
} else {
    http_response_code(400);
    echo json_encode(array("message" => "Incomplete data."));
}
?>
