<?php
include_once '../config/database.php';

$data = json_decode(file_get_contents("php://input"));

if(
    !empty($data->user_id) &&
    !empty($data->brand) &&
    !empty($data->model) &&
    !empty($data->plate_number)
){
    $query = "INSERT INTO vehicles SET user_id=:user_id, brand=:brand, model=:model, year=:year, plate_number=:plate_number";
    $stmt = $db->prepare($query);

    $stmt->bindParam(":user_id", $data->user_id);
    $stmt->bindParam(":brand", $data->brand);
    $stmt->bindParam(":model", $data->model);
    $year = !empty($data->year) ? $data->year : date('Y');
    $stmt->bindParam(":year", $year);
    $stmt->bindParam(":plate_number", $data->plate_number);

    if($stmt->execute()){
        http_response_code(201);
        echo json_encode(array("message" => "Vehicle created."));
    } else{
        http_response_code(503);
        echo json_encode(array("message" => "Unable to create vehicle."));
    }
} else {
    http_response_code(400);
    echo json_encode(array("message" => "Incomplete data."));
}
?>
