<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

include_once '../config/database.php';

$data = json_decode(file_get_contents("php://input"));

if (empty($data->workshop_id) || empty($data->service_name) || !isset($data->price)) {
    http_response_code(400);
    echo json_encode(array("message" => "Missing required fields (workshop_id, service_name, price)"));
    exit();
}

$query = "INSERT INTO services (workshop_id, service_name, price, category, description) VALUES (:workshop_id, :service_name, :price, :category, :description)";

$stmt = $db->prepare($query);
$stmt->bindParam(':workshop_id', $data->workshop_id);
$stmt->bindParam(':service_name', $data->service_name);
$stmt->bindParam(':price', $data->price);
$category = isset($data->category) ? $data->category : 'servis_rutin';
$description = isset($data->description) ? $data->description : '';
$stmt->bindParam(':category', $category);
$stmt->bindParam(':description', $description);

if ($stmt->execute()) {
    $service_id = $db->lastInsertId();
    http_response_code(201);
    echo json_encode(array("message" => "Service created.", "service_id" => $service_id));
} else {
    http_response_code(503);
    echo json_encode(array("message" => "Unable to create service."));
}
?>
