<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

include_once '../config/database.php';

$user_id = isset($_GET['user_id']) ? $_GET['user_id'] : die();

// 1. Get Workshop IDs owned by this user
$workshops_query = "SELECT workshop_id, name FROM workshops WHERE owner_id = :user_id";
$stmt = $db->prepare($workshops_query);
$stmt->bindParam(':user_id', $user_id);
$stmt->execute();

$workshops = $stmt->fetchAll(PDO::FETCH_ASSOC);

if(count($workshops) > 0) {
    $workshop_ids = array_column($workshops, 'workshop_id');
    $in_query = implode(',', array_fill(0, count($workshop_ids), '?'));

    // 2. Get Bookings for these workshops
    $query = "
        SELECT 
            b.booking_id, 
            b.booking_time, 
            b.status, 
            b.total_cost,
            u.full_name as customer_name,
            u.phone_number as customer_phone,
            w.name as workshop_name,
            v.brand,
            v.model,
            v.plate_number
        FROM bookings b
        JOIN users u ON b.user_id = u.user_id
        JOIN workshops w ON b.workshop_id = w.workshop_id
        LEFT JOIN vehicles v ON b.vehicle_id = v.vehicle_id
        WHERE b.workshop_id IN ($in_query)
        ORDER BY b.booking_time DESC
    ";

    $stmt2 = $db->prepare($query);
    foreach ($workshop_ids as $k => $id) $stmt2->bindValue(($k+1), $id);
    $stmt2->execute();

    $booking_arr = array();
    $booking_arr["data"] = array();
    $booking_arr["stats"] = array(
        "orders_today" => 0,
        "income_today" => 0
    );

    $today = date('Y-m-d');

    while ($row = $stmt2->fetch(PDO::FETCH_ASSOC)) {
        extract($row);

        // Simple stats calculation
        if (strpos($booking_time, $today) !== false) {
            $booking_arr["stats"]["orders_today"]++;
            if ($status == 'completed') {
                $booking_arr["stats"]["income_today"] += $total_cost;
            }
        }

        $booking_item = array(
            "booking_id" => $booking_id,
            "status" => $status,
            "date" => $booking_time,
            "customer_name" => $customer_name,
            "customer_phone" => $customer_phone,
            "workshop_name" => $workshop_name,
            "vehicle" => $brand ? "$brand $model ($plate_number)" : "Kendaraan Tidak Diketahui",
            "total_cost" => $total_cost
        );

        array_push($booking_arr["data"], $booking_item);
    }

    http_response_code(200);
    echo json_encode($booking_arr);

} else {
    // No workshops owned
    http_response_code(200);
    echo json_encode(array(
        "data" => [], 
        "stats" => ["orders_today" => 0, "income_today" => 0],
        "message" => "Anda belum memiliki bengkel."
    ));
}
?>
