<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

include_once '../config/database.php';

$data = json_decode(file_get_contents("php://input"));

if (empty($data->user_id) || empty($data->workshop_id)) {
    http_response_code(400);
    echo json_encode(array("message" => "Missing user_id or workshop_id"));
    exit();
}

try {
    // Check if conversation already exists
    $check = "SELECT conversation_id FROM conversations WHERE user_id = :user_id AND workshop_id = :workshop_id LIMIT 1";
    $check_stmt = $db->prepare($check);
    $check_stmt->bindParam(':user_id', $data->user_id);
    $check_stmt->bindParam(':workshop_id', $data->workshop_id);
    $check_stmt->execute();
    
    if ($check_stmt->rowCount() > 0) {
        // Return existing conversation
        $existing = $check_stmt->fetch(PDO::FETCH_ASSOC);
        echo json_encode(array("conversation_id" => $existing['conversation_id'], "is_new" => false));
    } else {
        // Create new conversation
        $insert = "INSERT INTO conversations (user_id, workshop_id) VALUES (:user_id, :workshop_id)";
        $ins_stmt = $db->prepare($insert);
        $ins_stmt->bindParam(':user_id', $data->user_id);
        $ins_stmt->bindParam(':workshop_id', $data->workshop_id);
        $ins_stmt->execute();
        
        $conversation_id = $db->lastInsertId();
        http_response_code(201);
        echo json_encode(array("conversation_id" => $conversation_id, "is_new" => true));
    }
    
} catch (Exception $e) {
    http_response_code(503);
    echo json_encode(array("message" => "Failed to start conversation. " . $e->getMessage()));
}
?>
