<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

include_once '../config/database.php';

$user_id = isset($_GET['user_id']) ? $_GET['user_id'] : null;
$role = isset($_GET['role']) ? $_GET['role'] : 'customer';

if (!$user_id) {
    http_response_code(400);
    echo json_encode(array("message" => "Missing user_id"));
    exit();
}

if ($role === 'owner') {
    // Get workshop_id for this owner first
    $ws_query = "SELECT workshop_id FROM workshops WHERE owner_id = :user_id LIMIT 1";
    $ws_stmt = $db->prepare($ws_query);
    $ws_stmt->bindParam(':user_id', $user_id);
    $ws_stmt->execute();
    
    if ($ws_stmt->rowCount() == 0) {
        echo json_encode([]);
        exit();
    }
    
    $workshop = $ws_stmt->fetch(PDO::FETCH_ASSOC);
    $workshop_id = $workshop['workshop_id'];
    
    // Get conversations for this workshop
    $query = "
        SELECT c.conversation_id, c.user_id, c.workshop_id, c.last_message_at,
               u.full_name as customer_name,
               (SELECT message FROM messages WHERE conversation_id = c.conversation_id ORDER BY sent_at DESC LIMIT 1) as last_message,
               (SELECT COUNT(*) FROM messages WHERE conversation_id = c.conversation_id AND sender_id != :owner_id AND is_read = 0) as unread_count
        FROM conversations c
        JOIN users u ON c.user_id = u.user_id
        WHERE c.workshop_id = :workshop_id
        ORDER BY c.last_message_at DESC
    ";
    $stmt = $db->prepare($query);
    $stmt->bindParam(':workshop_id', $workshop_id);
    $stmt->bindParam(':owner_id', $user_id);
} else {
    // Customer: get their conversations
    $query = "
        SELECT c.conversation_id, c.user_id, c.workshop_id, c.last_message_at,
               w.name as workshop_name,
               (SELECT message FROM messages WHERE conversation_id = c.conversation_id ORDER BY sent_at DESC LIMIT 1) as last_message,
               (SELECT COUNT(*) FROM messages WHERE conversation_id = c.conversation_id AND sender_id != :user_id AND is_read = 0) as unread_count
        FROM conversations c
        JOIN workshops w ON c.workshop_id = w.workshop_id
        WHERE c.user_id = :user_id
        ORDER BY c.last_message_at DESC
    ";
    $stmt = $db->prepare($query);
    $stmt->bindParam(':user_id', $user_id);
}

$stmt->execute();
$conversations = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo json_encode($conversations);
?>
