<?php
include_once '../config/database.php';

$data = json_decode(file_get_contents("php://input"));

if(!empty($data->booking_id) && !empty($data->status)) {
    
    $query = "UPDATE bookings SET status = :status WHERE booking_id = :booking_id";
    $stmt = $db->prepare($query);
    
    $stmt->bindParam(':status', $data->status);
    $stmt->bindParam(':booking_id', $data->booking_id);
    
    if($stmt->execute()) {
        http_response_code(200);
        echo json_encode(array("message" => "Status updated successfully."));
    } else {
        http_response_code(503);
        echo json_encode(array("message" => "Unable to update status."));
    }

} else {
    http_response_code(400);
    echo json_encode(array("message" => "Incomplete data."));
}
?>
