<?php
include_once '../config/database.php';

$data = json_decode(file_get_contents("php://input"));

if(!empty($data->user_id) && !empty($data->workshop_id)) {
    
    try {
        $db->beginTransaction();

        // 1. Insert into bookings
        $query = "INSERT INTO bookings (user_id, workshop_id, vehicle_id, status, total_cost, notes) 
                  VALUES (:user_id, :workshop_id, :vehicle_id, 'pending', :total_cost, :notes)";
        
        $stmt = $db->prepare($query);
        $vehicle_id = isset($data->vehicle_id) ? $data->vehicle_id : null; // Optional if not select vehicle
        $notes = isset($data->notes) ? $data->notes : '';

        $stmt->bindParam(":user_id", $data->user_id);
        $stmt->bindParam(":workshop_id", $data->workshop_id);
        $stmt->bindParam(":vehicle_id", $vehicle_id);
        $stmt->bindParam(":total_cost", $data->total_cost);
        $stmt->bindParam(":notes", $notes);
        
        $stmt->execute();
        $booking_id = $db->lastInsertId();

        // 2. Insert into booking_details (Services)
        if(!empty($data->services)) {
            $query_detail = "INSERT INTO booking_details (booking_id, service_id, price_at_booking) VALUES (:booking_id, :service_id, :price)";
            $stmt_detail = $db->prepare($query_detail);

            foreach($data->services as $service) {
                $stmt_detail->bindParam(":booking_id", $booking_id);
                $stmt_detail->bindParam(":service_id", $service->id);
                $stmt_detail->bindParam(":price", $service->price);
                $stmt_detail->execute();
            }
        }

        $db->commit();
        http_response_code(201);
        echo json_encode(array("message" => "Booking created.", "booking_id" => $booking_id));

    } catch (Exception $e) {
        $db->rollBack();
        http_response_code(503);
        echo json_encode(array("message" => "Unable to create booking. " . $e->getMessage()));
    }

} else {
    http_response_code(400);
    echo json_encode(array("message" => "Incomplete data."));
}
?>
